from asyncio import sleep
import imp
from importlib.util import module_for_loader
from webbrowser import get
from xmlrpc.client import FastMarshaller
# from fleming.hta.exc_psf_alpha_control import myalpha_on

from fleming.hta.fleming_measurement import *
from fleming.hta.hw_control import *
from fleming.hta.AxisScan import AxisScan, Scan
from fleming.hta.scantable_location import scantable_location, scantable_96plate_location, scantable_384plate_location
import math


import config_enum.scan_table_enum as scan_table_enum
import config_enum.detector_aperture_slider_enum as das_enum
from fleming.hta.exc_psf_alpha_control import *

from fleming.hta.static_functions import *

async def st_move_x(v):
    st = VUnits.instance.hal.scan_table
    x0,y0=st.get_current_position()
    await st.Move(v,y0)

async def st_move_y(v):
    st = VUnits.instance.hal.scan_table
    x0,y0=st.get_current_position()
    await st.Move(x0,v)


# fleming.hta.fleming_alignment.illuminationSwitch
async def elsIlluminationSwitch(mode="alpha"): # mode and range
    # for manual alignment, scan els and check backreflection
    await myInitialization()

    st = VUnits.instance.hal.scan_table
    await scanTable_init("'96 Test Plate'")
    await st.Move(60,0)

    tr=[250, 280]
    
    elsrange=tr
    elsScan=AxisScan(els.Move,elsrange,tr[1]-tr[0])
    timeseries=Scan([[elsScan]])
    

    if mode == "alpha":
        prefuncs=[[alpha_init],[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
        timeseries.functions([[timeseries.currentIndex],[kaleido_alpha,0.3,200,50,1,5]])
    elif mode=="lamp":
        prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,56.96]]
        timeseries.functions([[timeseries.currentIndex],[kaleido_FI,0.001]])
    elif mode=="TRF":
        prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,56.96]]
        timeseries.functions([[timeseries.currentIndex],[kaleido_trf_laser,1,10,100,1,0]])

    await timeseries.run()
    
    print(f"done!:\t{inspect.stack()[0][3]}")

# fleming.hta.fleming_alignment.psf_exc_pilotlaser_measure
async def psf_exc_pilotlaser_measure():
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]

    # well
    wellx=1
    welly=1
    z0=10
    r=1
    n=3
    # n=21
    rz=7
    nz=7
    
    st=scan_table
    await scanTable_init("'96 Test Plate'")
    # await st.MoveToWell(wellx,welly)
    # await st.Move()
    # x0,y0 = await scantable_location(75.38,156.885) # hamburg
    x0,y0 = await scantable_location(76.0,158.11) # swangsea

    x0,y0 = st.get_current_position()
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    psfscan=Scan([[xscan],[yscan]])
    # zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    # psfscan=Scan([[xscan],[yscan],[zscan]])
    
    prefuncs=[[abs_init,"1006"],[apertures,0,0],[els.Move,248.19],[fms.Move,56.4],[bld.Move,200.5],[fm.Move,10]]
    psfscan.functions([[psfscan.currentPos],[st.get_current_position],[kaleido_abs,100,True]])

    cmt = "pilotlaser_exc"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)

    await psfscan.run(fname,cmt, prefuncs=[])
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")
    return

# # fleming.hta.fleming_alignment.psf_exc_alpha_measure
# async def psf_exc_alpha(elsloc=204.0015,z0=10,comment=""):
#     await myInitialization()
#     elsloc=205
#     # well
#     wellx=1
#     welly=1
#     r=4
#     n=5
#     rz=9
#     nz=10

#     # x0,y0 = await scantable_location(75.38,156.885)
#     # x0,y0 = await scantable_location(75.87,158.365)
#     # x0,y0 = await scantable_location(75.87,158.365)
#     x0,y0 = await scantable_location(75.07,157.11)

#     xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
#     yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
#     psfscan=Scan([[xscan],[yscan]])
#     # zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
#     # psfscan=Scan([[xscan],[yscan],[zscan]])
#     psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode]])
#     prefuncs=[[alpha_photo_init],[apertures,0,0],[els.Move,elsloc],[fms.Move,56.4],[bld.Move,200.5]]
    
#     cmt = inspect.stack()[0][3]+comment
#     timestamp=True
#     fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
#     print(fname)
#     await psfscan.run(fname,cmt,prefuncs)

#     print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_alignment.psf_exc_trfLaser
# async def psf_exc_trfLaser_measure(elsloc=242.22,z0=12.5,comment=""):
async def psf_exc_trfLaser(elsloc=248.4,z0=11.0,filterModule=1006):
    # await myInitialization()
    # well
    wellx=1
    welly=1
    r=4
    n=11
    rz=7
    nz=8

    x0,y0 = await scantable_96plate_location(1,1)
    
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])

    await els.Home()
    prefuncs=[[trf_laser_photo_init,filterModule],[fms.Move,54.08],[apertures,0,0],[els.Move,elsloc],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,10, 100, 200]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    print(fname)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")
    print(x0,y0)


# fleming.hta.fleming_alignment.psf_exc_lamp
async def psf_exc_lamp(elsloc=204.0015,z0=10,comment=""):

    await myInitialization()

    # well
    wellx=1
    welly=1
    r=4
    n=21
    rz=9
    nz=10

    x0,y0 = await scantable_96plate_location(1,1)
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)    
    
    # await fm.Move(z0), 
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.01,False]])
    print(psfscan.dims)

    cmt = inspect.stack()[0][3]+comment
    timestamp=True
    prefuncs=[[abs_init,1006],[apertures,0,0],[els.Move,elsloc],[bld.Move,200.5]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)    
    print(fname)
    
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_alignment.psf_exc_pilot_measure
async def psf_exc_pilot_measure(elsloc=248.19,z0=10):
    await myInitialization()
    await scantable_96plate_location(1,1)

    # well
    wellx=1
    welly=1
    r=1
    n=11
    rz=9
    nz=10

    x0,y0 = await scantable_location(75.07,157.11)
    
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    await fm.Move(z0)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,100,True]])
    print(psfscan.dims)

    cmt = "psf_exc_pilot_3D_IAR+lens"
    timestamp=True
    prefuncs=[[abs_init,1006],[els.Move,elsloc],[fms.Move,54.5],[bld.Move,200.5]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    print(fname)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_alignment.psf_exc_alpha
async def psf_exc_alpha(elsloc=243.14,z0=12.5):
    await myInitialization()
    # well
    wellx=1
    welly=1
    z0=10
    r=4
    n=21
    rz=9
    nz=10

    # x0,y0 = await scantable_location(75.38,156.885)
    x0,y0 = await scantable_96plate_location(1,1)
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    
    await els.Home()
    prefuncs=[[alpha_photo_init],[apertures,0,0],[els.Move,elsloc],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode,0.001]]) # second # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    # prefuncs=[[alpha_init],[apertures,0,0],[els.Move,elsloc],[bld.Move,200]]
    # psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode]])

    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    
    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_alignment.psf_exc_det_FI_measure
async def psf_exc_det_FI_measure(elsloc=202.3375,z0=12.5):
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]

    # well
    wellx=1
    welly=4
    r=4
    n=21
    rz=9
    nz=10

    # x0,y0 = await scantable_location(75.38,156.885)
    x0,y0 = scan_table.get_current_position()
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_FI,0.1]])
    print(psfscan.dims)


    cmt = "psf_exc_det_FI"
    timestamp=True
    prefuncs=[[abs_init,1006],[apertures,0,0],[els.Move,elsloc],[fms.Move,54.5],[bld.Move,200.5],[das1.Move,11.45], [das2.Move,11.7]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    # await myalpha_on(0.3)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_alignment.psf_det_lum_pinhole
async def psf_det_lum_pinhole(z0=12.5,das1_shift=0,das2_shift=0):
    await myInitialization()
    wellx=4
    welly=3
    # z0=10
    r=4
    n=11
    rz=7
    nz=8
    wellx=3
    welly=1
    await scantable_96plate_location(wellx,welly)

    # wellx=11
    # welly=6
    # await scantable_384plate_location(wellx,welly)

    st = VUnits.instance.hal.scan_table
    x0,y0 =  st.get_current_position()
    
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    
    await fm.Move(z0)
    psfscan=Scan([[xscan],[yscan]])
    # zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    # psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_lum,100]])
    print(psfscan.dims)

    timestamp=True
    await apertures(1,1)
    pos=await get_all_mover_positions()
    await das1.Move(pos['das1_pos']+das1_shift)
    await das2.Move(pos['das2_pos']+das2_shift)
    

    prefuncs=[[lum_init,"1006"],[get_all_mover_positions]]
    # prefuncs=[[lum_init,"4003"],[get_all_mover_positions]]
    cmt=inspect.stack()[0][3]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    hv1,hv2=await get_hv()
    print(hv1,hv2)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_alignment.det_aperture_scan
async def det_aperture_scan(z0=10.0):
    await myInitialization()
    wellx=3
    welly=1
    await scantable_96plate_location(wellx,welly)

    das1 = VUnits.instance.hal.detectorApertureSlider1
    das2 = VUnits.instance.hal.detectorApertureSlider2

    max1 = 20
    max2 = 20

    dp=1
    n=round((max1-0)/dp)+1

    das1scan=AxisScan(das1.Move,[0,max1],n)
    das2scan=AxisScan(das2.Move,[0,max2],n)

    psfscan=Scan([[das1scan,das2scan]])
    prefuncs=[[abs_init,1006],[fms.Move,54.5],[fm.Move,z0],[get_all_mover_positions]] #,[set_dl, 0.245,0.246],[set_hv,0.455,0.455],[get_hv],[get_dl]] # 
    psfscan.functions([[psfscan.currentPos],[kaleido_lum,100]])

    fname=fnameGen(f"{instrument}_{inspect.stack()[0][3]}",timestamp=True,funcs=prefuncs)
    hv1,hv2=await get_hv()
    print(hv1,hv2)
    
    await psfscan.run(fname,inspect.stack()[0][3],prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_alignment.det_aperture_FI_scan
async def det_aperture_FI_scan(elsloc=204.0015):
    await myInitialization()
    wellx=1
    welly=4
    elsloc=202.372
    # await scantable_96plate_location(wellx,welly)
    await scantable_96plate_location(wellx,welly)

    das1 = VUnits.instance.hal.detectorApertureSlider1
    das2 = VUnits.instance.hal.detectorApertureSlider2

    await get_all_mover_positions()
    pos1 = round(das1.get_config(das_enum.Positions.Min), 2)
    pos2 = round(das2.get_config(das_enum.Positions.Min), 2)

    max1 = das1.get_config(das_enum.Positions.Max)
    max2 = das2.get_config(das_enum.Positions.Max)

    dp=0.05
    n=round((max1-pos1)/dp)

    das1scan=AxisScan(das1.Move,[pos1,max1],n)
    das2scan=AxisScan(das2.Move,[pos2,max2],n)
    psfscan=Scan([[das1scan,das2scan]])
    # psfscan=Scan([[das1scan]])
    # get_all_mover_positions
    await FI_init(filter_ID=1001, meas_height=15, meas_time=100, num_wells=96, top_meas=True)

    psfscan.functions([[psfscan.currentPos],[kaleido_FI,100]])
    print(psfscan.dims)

    cmt = "det_aperture_FI"
    timestamp=True
    # prefuncs=[[abs_init,"1006"],[els.Move,elsloc],[fms.Move,56.96],[fm.Move,11]] #,[set_dl, 0.245,0.246],[set_hv,0.455,0.455],[get_hv],[get_dl]] # 
    prefuncs=[[els.Move,elsloc],[fms.Move,54.5],[fm.Move,11]] #,[set_dl, 0.245,0.246],[set_hv,0.455,0.455],[get_hv],[get_dl]] # 
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    hv1,hv2=await get_hv()
    print(hv1,hv2)
    
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")



# fleming.hta.fleming_alignment.bottomlightRoughAlign
async def bottomlightRoughAlign():
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]
    # await header_output_Gen(prefuncs)
    await scantable_location(75.38,156.885)
    # await fm.Move(0) 
    l=130
    r=260
    n=(r-l)*4
    bldscan=AxisScan(bld.Move,[l,r],n)
    
    psfscan=Scan([[bldscan]])
    # psfscan=Scan([[xscan],[yscan]])
    dims=psfscan.dims
    prod=1
    for d in dims:
        prod*=d
    
    prefuncs=[[abs_init,"1006"],[fm.Move,12],[apertures,0,0],[els.Move,203.7],[fms.Move,56.96]]
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.1,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    print(psfscan.dims)
    cmt = "lamp_bld_full_scan"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_alignment.fms_photonDiode_trf_scan
async def fms_photonDiode_trf_scan(z0=13.5):
    await myInitialization()
    x0,y0 = await scantable_96plate_location(1,1)
    # await st.Home()
    filterModule=4003
    # await scantable_location(75.85,	158.31) # swansea
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filterModule)
    pos=await get_all_mover_positions()
    pos=pos['fms_pos']
    print(pos)
    # await fm.Move(0) 
    r=10
    n=round(r/0.1)
    fmsscan=AxisScan(fms.Move,[pos-r/2,pos+r/2],n)
    
    psfscan=Scan([[fmsscan]])

    prefuncs=[[trf_laser_photo_init,filterModule],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,10, 10, 1]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    
    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_alignment.els_photonDiode_alpha_scan
async def els_photonDiode_alpha_scan(z0=5.5):
    await myInitialization()
    await scantable_96plate_location(1,1)
    l=0
    r=360
    # l=236
    # r=252
    n=(r-l)*10+1
    l=246
    r=249
    l=241
    r=246
    n=round((r-l)*50+1)
    
    elsscan=AxisScan(els.Move,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    await els.Home()
    prefuncs=[[alpha_photo_init],[apertures,0,0],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode,0.001]]) # second # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    
    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")




# fleming.hta.fleming_alignment.els_photonDiode_trf_scan
async def els_photonDiode_trf_scan(z0=13.5):
    await myInitialization()
    await scantable_96plate_location(1,1)
    l=246
    r=252
    n=round((r-l)*40+1)
    elsscan=AxisScan(els.Move,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    await els.Home()
    prefuncs=[[trf_laser_photo_init,1006],[apertures,0,0],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    # psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,100, 100, 200]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    
    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# # fleming.hta.fleming_alignment.els_photonDiode_align
# async def els_photonDiode_align():
#     await myInitialization()
#     # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
#     # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]
#     # await header_output_Gen(prefuncs)
#     # await scantable_location(75.38,156.885) # Hamburg
#     # await scantable_location(75.85,	158.31) # swansea
#     await scantable_96plate_location(1,1)

#     # await fm.Move(0) 
#     l=0
#     r=360
#     n=(r-l)*4
#     # n=(r-l)
#     elsscan=AxisScan(els.Move,[l,r],n)
    
#     psfscan=Scan([[elsscan]])
#     # psfscan=Scan([[xscan],[yscan]])
#     dims=psfscan.dims
#     prod=1
#     for d in dims:
#         prod*=d
    
#     prefuncs=[[abs_init,"1006"],[fm.Move,12],[fms.Move,56.96],[bld.Move,196]]
#     # psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.1,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
#     psfscan.functions([[psfscan.currentPos],[kaleido_abs,100,True]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
#     print(psfscan.dims)
#     cmt = inspect.stack()[0][3]
#     timestamp=True
#     fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
#     await psfscan.run(fname,cmt,prefuncs)

#     print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_alignment.els_flashlamp1_align
async def els_flashlamp1_align(z0=10.5):
    # await myInitialization()
    # x0,y0 = await scantable_location(75.07,157.11)
    await scantable_96plate_location(1,1)
    # await fm.Move(0)
    l=13
    r=30

    # l=197
    # r=208

    n=(r-l)*50+1
    elsscan=AxisScan(els.Move,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    await els.Home()

    prefuncs=[[abs_init,1006],[fm.Move,z0],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,100,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    print(psfscan.dims)

    cmt = inspect.stack()[0][3]
    fname=fnameGen(f"{instrument}_{cmt}",tstemp=True,funcs=prefuncs)

    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")

# fleming.hta.fleming_alignment.els_flashlamp2_align
async def els_flashlamp2_align(z0=7.5):
    # await myInitialization()
    # x0,y0 = await scantable_location(75.07,157.11)
    await scantable_96plate_location(1,1)
    # await fm.Move(0)
    l=197
    r=208

    n=(r-l)*50+1
    elsscan=AxisScan(els.Move,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    await els.Home()
    
    prefuncs=[[abs_init,1006],[fm.Move,z0],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,100,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    print(psfscan.dims)

    cmt = inspect.stack()[0][3]
    fname=fnameGen(f"{instrument}_{cmt}",tstemp=True,funcs=prefuncs)

    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")

# fleming.hta.fleming_alignment.photonDiode_align
async def photonDiode_align():
    await myInitialization()
    await scantable_location(0,0)
    # await fm.Move(0) 
    l=0
    r=360
    n=round((r-l))
    axbld=AxisScan(bld.Move,[l,r],n)
    
    bldscan=Scan([[axbld]])
    # psfscan=Scan([[xscan],[yscan]])
    prefuncs=[[abs_init,"1006"],[fm.Move,12],[els.Move,248.19],[fms.Move,56.96]]
    # bldscan.functions([[bldscan.currentPos],[kaleido_abs,100,True]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    bldscan.functions([[bldscan.currentPos],[kaleido_abs,100,False]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    await bldscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")

# fleming.hta.fleming_alignment.fi_zscan
async def fi_zscan():
    await myInitialization()
    wellx=8
    welly=3
    await scantable_96plate_location(wellx,welly)

    l=0
    r=17.8
    n=round((r-l))
    axfm=AxisScan(fm.Move,[l,r],n)
    
    fmscan=Scan([[axfm]])
    # psfscan=Scan([[xscan],[yscan]])
    # prefuncs=[[FI_init,"1006"],[els.Move,204.015],[fms.Move,54.5],[bld.Move,242.15]]
    prefuncs=[[lum_init,"1006"],[els.Move,204.015],[bld.Move,242.15]]
    prefuncs=[]
    # bldscan.functions([[bldscan.currentPos],[kaleido_FI,0.1]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    fmscan.functions([[fmscan.currentPos],[kaleido_lum,100]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    await fmscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")

# fleming.hta.fleming_alignment.procedure
async def procedure():
    # 1. rough els scan to find the positions
    # 2. 3d psfs to find the z focus
    # 3. els scan at each focus.
    # 4. double check 3d psfs again. (tune the scantable y position)
    # 5. detection psf find the focus.
    # 6. use the right focus and make 2D scan to tune the scan table x position
    # 7. tune the detection aperture.
    # 8. double check with FI.
    # good luck.
    # print('start')
    # await psf_exc_trfLaser(elsloc=248.85,z0=11,comment="")
    
    detection_shifting=False
    if detection_shifting:
        pos = await get_all_mover_positions()
        
        print(pos['das1_pos'])
        # pos['das1']
        # await set_all_mover_positions(pos)
        await das1.Home()
        await das2.Home()
        await psf_det_lum_pinhole(z0=12.5)
    
    roughExc=False
    if roughExc:
        await psf_exc_trfLaser(elsloc=248.4,z0=11,comment="")
        await psf_exc_alpha(elsloc=243.12,z0=12.5)
        await psf_exc_trfLaser(elsloc=248.85,z0=13.5)
    roughDet=False
    if roughDet:
        await psf_det_lum_pinhole(z0=12.5)

    elsScan=False
    if elsScan:
        # await els_photonDiode_alpha_scan(z0=5.5)
        await els_photonDiode_trf_scan(z0=13.5)
        # await els_flashlamp1_align(z0=10.5)
        # await els_flashlamp2_align(z0=7.5)
    excCheck=False
    if excCheck:
        await els.Home()
        await psf_exc_trfLaser(elsloc=248.85,z0=13.5)
        # await psf_exc_alpha(elsloc=243.02,z0=5.5)
        # await psf_exc_lamp(elsloc=22.62,z0=10.5)
        # await psf_exc_lamp(elsloc=203.14,z0=7.5)
    detectPSF=False
    if detectPSF: # 1:1
        await psf_det_lum_pinhole()
    
    overallPSF=False
    if overallPSF:
        await psf_exc_det_FI_measure()
        
    fmsScan=True
    if fmsScan:
        # await fms_photonDiode_trf_scan(z0=12.5)
        await psf_exc_trfLaser(elsloc=248.85,z0=12.5,filterModule=4003)

# fleming.hta.fleming_alignment
async def st_scalingfactor(elsloc=22.62,z0=10,wellx=1,welly=1):
    await myInitialization()
    # well
    r=4
    n=21
    rz=9
    nz=10

    x0,y0 = await scantable_96plate_location(wellx,welly)

    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)    
    
    await fm.Move(z0), 
    psfscan=Scan([[xscan],[yscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.001,False]])
    print(psfscan.dims)

    cmt = inspect.stack()[0][3]
    timestamp=True
    prefuncs=[[abs_init,1006],[apertures,0,0],[els.Move,elsloc],[bld.Move,200.5]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)    
    print(fname)
    
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")

# fleming.hta.fleming_alignment.scalingfactor_batch
async def scalingfactor_batch():
    await st_scalingfactor(elsloc=22.62,z0=10,wellx=1,welly=1)
    await st_scalingfactor(elsloc=22.62,z0=10,wellx=12,welly=1)


async def psfScan(xr,xn,yr,yn,zr,zn,prefuncs,funcs):
    
    x0,y0=st.get_current_position()
    z0 = fm.getPosition()
    
    xscan=AxisScan(st_move_x,[-xr/2+x0,xr/2+x0],xn)
    yscan=AxisScan(st_move_y,[-yr/2+y0,yr/2+y0],yn)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-zr/2,z0+zr/2],zn)
    psf=Scan([[xscan],[yscan],[zscan]])

async def timeSeries(*args):
    pass

async def close():
    pd = VUnits.instance.hal.plateDoor
    await pd.UseProfile(1)    
    await pd.Close()
    return
async def open():
    pd = VUnits.instance.hal.plateDoor
    await pd.UseProfile(1)    
    await pd.Open()
    return



# fleming.hta.fleming_alignment.temp
async def temp():
    print("start")
    await myInitialization()
    # await scan_table.Home()
    # await fms.Move(0)
    # pd = VUnits.instance.hal.plateDoor
    # await pd.UseProfile(1)    
    # await pd.Close()
    # await pd.Home()
    # await els.Home()
    await eject()
    return
    if False:
        await els.Move(248.7)
        
        await fms.Move(55.4+24*2)
        await st.Home()
        # await fms.Move(0)
        # return
        await fm.Move(0)
        # await alpha_init()
        # for i in range(1):
        re=await kaleido_trf_laser_photodiode(10000)
        print(re)
    # await alpha_photo_init()
    await els.Move(243.14)
    for i in range(200):
        re=await kaleido_alpha_photodiode(0.001)
        # await els.Move(23.14)
        # re=await kaleido_abs(200,False)
        print(re)
    # # await scantable_96plate_location(1,1)
    
    
    # return
    # # await pd.Open()
    # await eject()
    # # await load()
    # await fm.Move(17)
    # await lum_init(1006)
    pos=await get_all_mover_positions()
    pos['els_pos']+=1.0
    await set_all_mover_positions(pos)

    
    re =await kaleido_lum(1000)
    print(re)
    return

    prefuncs=[[els.Move,248.22],[bld.Move,0.5],[fms.Move,54.5]] # ,[apertures,0,0]] # Hamburg pilot lase testing script
    # prefuncs=[[els.Move,248.22],[bld.Move,200.5],[fms.Move,0]] # ,[apertures,0,0]] # Hamburg pilot lase testing script
    # await header_output_Gen(prefuncs)
    # return
    # for i in linspace(54,57,20):
    #     print(i)
    #     await fms.Move(i)
    #     input("Press Enter to continue...")

    input("Press Enter to continue...")
    for i in linspace(0,17,17):
        print(i)
        await fm.Move(i)
        await sleep(0.5)
    wellx=11
    welly=6
